/*
 * Decompiled with CFR 0.152.
 */
package com.pfg.mi1robot;

import com.pfg.mi1robot.Bitmap;
import com.pfg.mi1robot.Comandos;
import com.pfg.mi1robot.Escenario;
import com.pfg.mi1robot.Robot;
import java.awt.Color;
import java.awt.Graphics;
import java.io.BufferedInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class ColorComando
extends Comandos {
    public int colorHexadecimal;

    public ColorComando(int X, int Y, Bitmap grafico) {
        this.setNombre("Color Condicion");
        this.setTipo("Condicional");
        this.setX(X);
        this.setY(Y);
        this.grafico = grafico;
        this.colorHexadecimal = -1;
    }

    public void setColor(int color) {
        this.colorHexadecimal = color;
    }

    public int getColor() {
        return this.colorHexadecimal;
    }

    @Override
    public void draw(Graphics g, int xcord, int ycord) {
        if (this.colorHexadecimal == -1) {
            g.drawImage(this.grafico.getImagen(), this.getX() - xcord, this.getY() - ycord, null);
        } else {
            Color c = new Color(this.colorHexadecimal);
            g.setColor(c);
            g.fillRect(this.getX() - xcord, this.getY() - ycord, 32, 32);
        }
    }

    @Override
    public void exec(Robot robot, Escenario escenario) {
        this.sndPool.start();
        escenario.setColor(robot.getX(), robot.getY(), this.colorHexadecimal);
    }

    @Override
    public Comandos clone() {
        return new ColorComando(this.getX(), this.getY(), this.grafico);
    }

    @Override
    public void loadSound() throws LineUnavailableException, UnsupportedAudioFileException, IOException {
        BufferedInputStream bis = new BufferedInputStream(this.getClass().getResourceAsStream("pintar.wav"));
        AudioInputStream ais = AudioSystem.getAudioInputStream(bis);
        this.sndPool = AudioSystem.getClip();
        this.sndPool.open(ais);
    }
}

